#ifndef LLF_HMAC_H
#define LLF_HMAC_H

/*
* All the includes that are needed for code using this module to
* Compile correctly should be #included here.
*/

#include "CE2_public.h"
#include "CE2_HASH.h"

#ifdef __cplusplus
extern "C"
{
#endif

/*
* Creation date : Fri Mar 02 10:42:31 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains declaration of low level function
* provides a HASH function for processing one buffer of data,
* which worked with LibTomCrypt.
* 
* \version LLF_HMAC.h#1:csrc:1
* \author Pavel Sasunkevich
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Defines *****************************/
/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Structs *****************************/
/************************ Public Variables ********************/
/************************ Public Functions ********************/

/**
****************************************************************
* Function Name: 
*  LLF_HMAC
*
* Inputs:
* @param OperationMode [in] - The operation mode:
*                  SHA1, SHA224, SHA256, SHA384, SHA512, MD5;
* @param key_ptr [in] - The pointer to the user's key buffer;
* @param keySize [in] - The size of the received key;
* @param DataIn_ptr [in] - A pointer to the buffer that stores the data to be hashed;
* @param DataSize [in] - The size of the data to be hashed, in bytes;
* @param HmacResultBuff [out] - A pointer to the target buffer where the 
*                   HMAC result stored in the context is loaded to;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*   The function allocates an internal HASH Context, it initializes the 
* HASH Context with the cryptographic attributes that are needed for 
* the HASH block operation (initializes H's value for the HASH algorithm).
* Next the function loads the engine with the initializing values, 
* and then processes the data block, calculating the hash.
* Finally, the function return the message digest of the data buffer .
*
* \b
* Algorithm:
*  -# Initialize HASH machine;
*  -# Perform hash operation.
***************************************************************/
CE2Error_t LLF_HMAC    ( CE2_HASH_OperationMode_t  OperationMode,	/* in */
                         DxUint8_t                 *key_ptr,		/* in */
                         DxUint16_t                keySize,			/* in */
                         DxUint8_t                 *DataIn_ptr,		/* in */
                         DxUint32_t                DataSize,		/* in */
                         CE2_HASH_Result_t         HmacResultBuff );/* out */

#ifdef __cplusplus
}
#endif

#endif /* LLF_HMAC_H */
